import 'package:flutter/material.dart';
import 'package:osm_nominatim/osm_nominatim.dart';
import 'package:freezed_annotation/freezed_annotation.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

import '../../domain/models/models.dart';

part 'select_address_state.freezed.dart';

@freezed
class SelectAddressState with _$SelectAddressState {
  const factory SelectAddressState({
    @Default(false) bool isLoading,
    @Default(false) bool isActive,
    @Default(false) bool isSearching,
    @Default(false) bool isChoosing,
    @Default(false) bool isButtonLoading,
    @Default([]) List<Place> searchedPlaces,
    TextEditingController? textController,
    GoogleMapController? mapController,
    @Default(false) bool searchingMyLocation,
    LocationData? location,
    @Default("") String zipCode,
  }) = _SelectAddressState;

  const SelectAddressState._();
}
